//
//  GameInput.cs
//
//  Author:
//       Groundhog Dev <devgroundhog@gmail.com>
//
//  Copyright (c) 2025 Groundhog Dev
public static class GameRandom
{
    private static Random Random { get => _random ??= new Random(); }
    private static Random? _random;

    /*
        Returns a random number between the given min and max.
    */
    public static int Number(int min, int max)
    {
        return Random.Next(min, max + 1);
    }

    public static bool Event(double probability = 0.5)
    {
        return DecimalNumber() <= probability;
    }

    public static double DecimalNumber() // between 0 - 1
    {
        return Random.NextDouble();
    }

    public static double DecimalNumber(double min, double max)
    {
        double random = Random.NextDouble();
        return min + (random * (max - min));
    }
}